/**
 *  \file TripletScore.h    \brief Define TripletScore.
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2010 IMP Inventors. All rights reserved.
 */

#ifndef IMP_TRIPLET_SCORE_H
#define IMP_TRIPLET_SCORE_H

#include "kernel_config.h"
#include "base_types.h"
#include "Particle.h"
#include "DerivativeAccumulator.h"
#include "internal/container_helpers.h"

IMP_BEGIN_NAMESPACE

//! Abstract score function
/** TripletScores will evaluate the score and derivatives
    for the passed particles. Use in conjunction with various
    restraints such as IMP::core::TripletsRestraint or
    IMP::core::TripletRestraint.

    Implementers should check out IMP_TRIPLET_SCORE().
*/
class IMPEXPORT TripletScore : public Object
{
public:
  TripletScore(std::string name="TripletScore %1%");
  //! Compute the score and the derivative if needed.
  virtual double evaluate(const ParticleTriplet& vt,
                          DerivativeAccumulator *da) const = 0;

#if !defined(IMP_DOXYGEN) && 3 != 1
  // backwards compatibility
  virtual double evaluate(Particle *a, Particle *b, Particle *c,
                          DerivativeAccumulator *da) const {
    return evaluate(ParticleTriplet(a,b,c), da);
  }
#endif

  /** Implementations
      for these are provided by the IMP_TRIPLET_SCORE()
      macro.
  */
  virtual double evaluate(const ParticleTripletsTemp &o,
                          DerivativeAccumulator *da) const = 0;

  /** \name Incremental evaluation
      Compute how much the score has changed since the last evaluate
      (and writing derivatives if they have changed). Implementations
      for these are provided by the IMP_TRIPLET_SCORE() macro.
      @{
  */
  virtual double evaluate_change(const ParticleTriplet& vt,
                                 DerivativeAccumulator *da) const = 0;

  virtual double evaluate_change(const ParticleTripletsTemp &o,
                                 DerivativeAccumulator *da) const = 0;
  virtual double evaluate_prechange(const ParticleTriplet& vt,
                                    DerivativeAccumulator *da) const = 0;
  virtual double evaluate_prechange(const ParticleTripletsTemp &o,
                                    DerivativeAccumulator *da) const = 0;
  //! Return true if the score for vt might have changed.
  virtual bool get_is_changed(const ParticleTriplet& vt) const =0;
  /** @} */

  /** Get the set of interaction induced by applying to the
      argument. */
  virtual ParticlesList
    get_interacting_particles(const ParticleTriplet& vt) const =0;

  /** Get the set of particles read when applied to the arguments. */
  virtual ParticlesTemp
    get_input_particles(const ParticleTriplet& vt) const =0;

  /** Get the set of input containers when this modifier is applied to
      the arguments. */
  virtual ContainersTemp
    get_input_containers(const ParticleTriplet& vt) const =0;

  IMP_REF_COUNTED_DESTRUCTOR(TripletScore);
};

IMP_OBJECTS(TripletScore);
/** \objects{TripletScore}
*/
/** \objectstemp{TripletScore}
*/
IMP_END_NAMESPACE

#endif  /* IMP_TRIPLET_SCORE_H */
